(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/components/LogoLoop.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "LogoLoop",
    ()=>LogoLoop,
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature(), _s1 = __turbopack_context__.k.signature(), _s2 = __turbopack_context__.k.signature(), _s3 = __turbopack_context__.k.signature();
"use client";
;
;
const ANIMATION_CONFIG = {
    SMOOTH_TAU: 0.25,
    MIN_COPIES: 2,
    COPY_HEADROOM: 2
};
const toCssLength = (value)=>typeof value === "number" ? `${value}px` : value;
const useResizeObserver = (callback, elements, dependencies)=>{
    _s();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useResizeObserver.useEffect": ()=>{
            if (!window.ResizeObserver) {
                const handleResize = {
                    "useResizeObserver.useEffect.handleResize": ()=>callback()
                }["useResizeObserver.useEffect.handleResize"];
                window.addEventListener("resize", handleResize);
                callback();
                return ({
                    "useResizeObserver.useEffect": ()=>window.removeEventListener("resize", handleResize)
                })["useResizeObserver.useEffect"];
            }
            const observers = elements.map({
                "useResizeObserver.useEffect.observers": (ref)=>{
                    if (!ref.current) return null;
                    const observer = new ResizeObserver(callback);
                    observer.observe(ref.current);
                    return observer;
                }
            }["useResizeObserver.useEffect.observers"]);
            callback();
            return ({
                "useResizeObserver.useEffect": ()=>{
                    observers.forEach({
                        "useResizeObserver.useEffect": (observer)=>observer?.disconnect()
                    }["useResizeObserver.useEffect"]);
                }
            })["useResizeObserver.useEffect"];
        }
    }["useResizeObserver.useEffect"], [
        callback,
        elements,
        dependencies
    ]);
};
_s(useResizeObserver, "OD7bBpZva5O2jO+Puf00hKivP7c=");
const useImageLoader = (seqRef, onLoad, dependencies)=>{
    _s1();
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useImageLoader.useEffect": ()=>{
            const images = seqRef.current?.querySelectorAll("img") ?? [];
            if (images.length === 0) {
                onLoad();
                return;
            }
            let remainingImages = images.length;
            const handleImageLoad = {
                "useImageLoader.useEffect.handleImageLoad": ()=>{
                    remainingImages -= 1;
                    if (remainingImages === 0) onLoad();
                }
            }["useImageLoader.useEffect.handleImageLoad"];
            images.forEach({
                "useImageLoader.useEffect": (img)=>{
                    const htmlImg = img;
                    if (htmlImg.complete) {
                        handleImageLoad();
                    } else {
                        htmlImg.addEventListener("load", handleImageLoad, {
                            once: true
                        });
                        htmlImg.addEventListener("error", handleImageLoad, {
                            once: true
                        });
                    }
                }
            }["useImageLoader.useEffect"]);
            return ({
                "useImageLoader.useEffect": ()=>{
                    images.forEach({
                        "useImageLoader.useEffect": (img)=>{
                            img.removeEventListener("load", handleImageLoad);
                            img.removeEventListener("error", handleImageLoad);
                        }
                    }["useImageLoader.useEffect"]);
                }
            })["useImageLoader.useEffect"];
        }
    }["useImageLoader.useEffect"], [
        onLoad,
        seqRef,
        dependencies
    ]);
};
_s1(useImageLoader, "OD7bBpZva5O2jO+Puf00hKivP7c=");
const useAnimationLoop = (trackRef, targetVelocity, seqWidth, seqHeight, isHovered, hoverSpeed, isVertical)=>{
    _s2();
    const rafRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const lastTimestampRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const offsetRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(0);
    const velocityRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(0);
    (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useEffect"])({
        "useAnimationLoop.useEffect": ()=>{
            const track = trackRef.current;
            if (!track) return;
            const seqSize = isVertical ? seqHeight : seqWidth;
            if (seqSize > 0) {
                offsetRef.current = (offsetRef.current % seqSize + seqSize) % seqSize;
                const transformValue = isVertical ? `translate3d(0, ${-offsetRef.current}px, 0)` : `translate3d(${-offsetRef.current}px, 0, 0)`;
                track.style.transform = transformValue;
            }
            const animate = {
                "useAnimationLoop.useEffect.animate": (timestamp)=>{
                    if (lastTimestampRef.current === null) {
                        lastTimestampRef.current = timestamp;
                    }
                    const deltaTime = Math.max(0, timestamp - lastTimestampRef.current) / 1000;
                    lastTimestampRef.current = timestamp;
                    const target = isHovered && hoverSpeed !== undefined ? hoverSpeed : targetVelocity;
                    const easingFactor = 1 - Math.exp(-deltaTime / ANIMATION_CONFIG.SMOOTH_TAU);
                    velocityRef.current += (target - velocityRef.current) * easingFactor;
                    if (seqSize > 0) {
                        let nextOffset = offsetRef.current + velocityRef.current * deltaTime;
                        nextOffset = (nextOffset % seqSize + seqSize) % seqSize;
                        offsetRef.current = nextOffset;
                        const transformValue = isVertical ? `translate3d(0, ${-offsetRef.current}px, 0)` : `translate3d(${-offsetRef.current}px, 0, 0)`;
                        track.style.transform = transformValue;
                    }
                    rafRef.current = requestAnimationFrame(animate);
                }
            }["useAnimationLoop.useEffect.animate"];
            rafRef.current = requestAnimationFrame(animate);
            return ({
                "useAnimationLoop.useEffect": ()=>{
                    if (rafRef.current !== null) {
                        cancelAnimationFrame(rafRef.current);
                        rafRef.current = null;
                    }
                    lastTimestampRef.current = null;
                }
            })["useAnimationLoop.useEffect"];
        }
    }["useAnimationLoop.useEffect"], [
        targetVelocity,
        seqWidth,
        seqHeight,
        isHovered,
        hoverSpeed,
        isVertical,
        trackRef
    ]);
};
_s2(useAnimationLoop, "CHkB9QIrZTEfgjfB6nwY5WHuHxk=");
const LogoLoop = /*#__PURE__*/ _s3((0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["memo"])(_c = _s3(({ logos, speed = 120, direction = "left", width = "100%", logoHeight = 28, gap = 32, pauseOnHover, hoverSpeed, fadeOut = false, fadeOutColor, scaleOnHover = false, renderItem, ariaLabel = "Partner logos", className, style })=>{
    _s3();
    const containerRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const trackRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const seqRef = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useRef"])(null);
    const [seqWidth, setSeqWidth] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(0);
    const [seqHeight, setSeqHeight] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(0);
    const [copyCount, setCopyCount] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(ANIMATION_CONFIG.MIN_COPIES);
    const [isHovered, setIsHovered] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    const effectiveHoverSpeed = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[effectiveHoverSpeed]": ()=>{
            if (hoverSpeed !== undefined) return hoverSpeed;
            if (pauseOnHover === true) return 0;
            if (pauseOnHover === false) return undefined;
            return 0;
        }
    }["LogoLoop.useMemo[effectiveHoverSpeed]"], [
        hoverSpeed,
        pauseOnHover
    ]);
    const isVertical = direction === "up" || direction === "down";
    const targetVelocity = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[targetVelocity]": ()=>{
            const magnitude = Math.abs(speed);
            const directionMultiplier = isVertical ? direction === "up" ? 1 : -1 : direction === "left" ? 1 : -1;
            const speedMultiplier = speed < 0 ? -1 : 1;
            return magnitude * directionMultiplier * speedMultiplier;
        }
    }["LogoLoop.useMemo[targetVelocity]"], [
        speed,
        direction,
        isVertical
    ]);
    const updateDimensions = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "LogoLoop.useCallback[updateDimensions]": ()=>{
            const containerWidth = containerRef.current?.clientWidth ?? 0;
            const sequenceRect = seqRef.current?.getBoundingClientRect?.();
            const sequenceWidth = sequenceRect?.width ?? 0;
            const sequenceHeight = sequenceRect?.height ?? 0;
            if (isVertical) {
                const parentHeight = containerRef.current?.parentElement?.clientHeight ?? 0;
                if (containerRef.current && parentHeight > 0) {
                    const targetHeight = Math.ceil(parentHeight);
                    if (containerRef.current.style.height !== `${targetHeight}px`) containerRef.current.style.height = `${targetHeight}px`;
                }
                if (sequenceHeight > 0) {
                    setSeqHeight(Math.ceil(sequenceHeight));
                    const viewport = containerRef.current?.clientHeight ?? parentHeight ?? sequenceHeight;
                    const copiesNeeded = Math.ceil(viewport / sequenceHeight) + ANIMATION_CONFIG.COPY_HEADROOM;
                    setCopyCount(Math.max(ANIMATION_CONFIG.MIN_COPIES, copiesNeeded));
                }
            } else if (sequenceWidth > 0) {
                setSeqWidth(Math.ceil(sequenceWidth));
                const copiesNeeded = Math.ceil(containerWidth / sequenceWidth) + ANIMATION_CONFIG.COPY_HEADROOM;
                setCopyCount(Math.max(ANIMATION_CONFIG.MIN_COPIES, copiesNeeded));
            }
        }
    }["LogoLoop.useCallback[updateDimensions]"], [
        isVertical
    ]);
    useResizeObserver(updateDimensions, [
        containerRef,
        seqRef
    ], [
        logos,
        gap,
        logoHeight,
        isVertical
    ]);
    useImageLoader(seqRef, updateDimensions, [
        logos,
        gap,
        logoHeight,
        isVertical
    ]);
    useAnimationLoop(trackRef, targetVelocity, seqWidth, seqHeight, isHovered, effectiveHoverSpeed, isVertical);
    const cssVariables = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[cssVariables]": ()=>({
                "--logoloop-gap": `${gap}px`,
                "--logoloop-logoHeight": `${logoHeight}px`,
                ...fadeOutColor && {
                    "--logoloop-fadeColor": fadeOutColor
                }
            })
    }["LogoLoop.useMemo[cssVariables]"], [
        gap,
        logoHeight,
        fadeOutColor
    ]);
    const rootClassName = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[rootClassName]": ()=>[
                "logoloop",
                isVertical ? "logoloop--vertical" : "logoloop--horizontal",
                fadeOut && "logoloop--fade",
                scaleOnHover && "logoloop--scale-hover",
                className
            ].filter(Boolean).join(" ")
    }["LogoLoop.useMemo[rootClassName]"], [
        isVertical,
        fadeOut,
        scaleOnHover,
        className
    ]);
    const handleMouseEnter = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "LogoLoop.useCallback[handleMouseEnter]": ()=>{
            if (effectiveHoverSpeed !== undefined) setIsHovered(true);
        }
    }["LogoLoop.useCallback[handleMouseEnter]"], [
        effectiveHoverSpeed
    ]);
    const handleMouseLeave = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "LogoLoop.useCallback[handleMouseLeave]": ()=>{
            if (effectiveHoverSpeed !== undefined) setIsHovered(false);
        }
    }["LogoLoop.useCallback[handleMouseLeave]"], [
        effectiveHoverSpeed
    ]);
    const renderLogoItem = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useCallback"])({
        "LogoLoop.useCallback[renderLogoItem]": (item, key)=>{
            if (renderItem) {
                return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("li", {
                    className: "logoloop__item",
                    role: "listitem",
                    children: renderItem(item, key)
                }, key, false, {
                    fileName: "[project]/components/LogoLoop.tsx",
                    lineNumber: 323,
                    columnNumber: 13
                }, ("TURBOPACK compile-time value", void 0));
            }
            const isNodeItem = "node" in item;
            const content = isNodeItem ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                className: "logoloop__node",
                "aria-hidden": !!item.href && !item.ariaLabel,
                children: item.node
            }, void 0, false, {
                fileName: "[project]/components/LogoLoop.tsx",
                lineNumber: 330,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0)) : /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("img", {
                src: item.src,
                srcSet: item.srcSet,
                sizes: item.sizes,
                width: item.width,
                height: item.height,
                alt: item.alt ?? "",
                title: item.title,
                loading: "lazy",
                decoding: "async",
                draggable: false
            }, void 0, false, {
                fileName: "[project]/components/LogoLoop.tsx",
                lineNumber: 337,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0));
            const itemAriaLabel = isNodeItem ? item.ariaLabel ?? item.title : item.alt ?? item.title;
            const itemContent = item.href ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("a", {
                className: "logoloop__link",
                href: item.href,
                "aria-label": itemAriaLabel || "logo link",
                target: "_blank",
                rel: "noreferrer noopener",
                children: content
            }, void 0, false, {
                fileName: "[project]/components/LogoLoop.tsx",
                lineNumber: 354,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0)) : content;
            return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("li", {
                className: "logoloop__item",
                role: "listitem",
                children: itemContent
            }, key, false, {
                fileName: "[project]/components/LogoLoop.tsx",
                lineNumber: 367,
                columnNumber: 11
            }, ("TURBOPACK compile-time value", void 0));
        }
    }["LogoLoop.useCallback[renderLogoItem]"], [
        renderItem
    ]);
    const logoLists = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[logoLists]": ()=>Array.from({
                length: copyCount
            }, {
                "LogoLoop.useMemo[logoLists]": (_, copyIndex)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("ul", {
                        className: "logoloop__list",
                        role: "list",
                        "aria-hidden": copyIndex > 0,
                        ref: copyIndex === 0 ? seqRef : undefined,
                        children: logos.map({
                            "LogoLoop.useMemo[logoLists]": (item, itemIndex)=>renderLogoItem(item, `${copyIndex}-${itemIndex}`)
                        }["LogoLoop.useMemo[logoLists]"])
                    }, `copy-${copyIndex}`, false, {
                        fileName: "[project]/components/LogoLoop.tsx",
                        lineNumber: 378,
                        columnNumber: 11
                    }, ("TURBOPACK compile-time value", void 0))
            }["LogoLoop.useMemo[logoLists]"])
    }["LogoLoop.useMemo[logoLists]"], [
        copyCount,
        logos,
        renderLogoItem
    ]);
    const containerStyle = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useMemo"])({
        "LogoLoop.useMemo[containerStyle]": ()=>({
                width: isVertical ? toCssLength(width) === "100%" ? undefined : toCssLength(width) : toCssLength(width) ?? "100%",
                ...cssVariables,
                ...style
            })
    }["LogoLoop.useMemo[containerStyle]"], [
        width,
        cssVariables,
        style,
        isVertical
    ]);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
        ref: containerRef,
        className: rootClassName,
        style: containerStyle,
        role: "region",
        "aria-label": ariaLabel,
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
            className: "logoloop__track",
            ref: trackRef,
            onMouseEnter: handleMouseEnter,
            onMouseLeave: handleMouseLeave,
            children: logoLists
        }, void 0, false, {
            fileName: "[project]/components/LogoLoop.tsx",
            lineNumber: 414,
            columnNumber: 9
        }, ("TURBOPACK compile-time value", void 0))
    }, void 0, false, {
        fileName: "[project]/components/LogoLoop.tsx",
        lineNumber: 407,
        columnNumber: 7
    }, ("TURBOPACK compile-time value", void 0));
}, "1cSCLDI9jga6+sjc7wQeKQCn0r0=", false, function() {
    return [
        useResizeObserver,
        useImageLoader,
        useAnimationLoop
    ];
})), "1cSCLDI9jga6+sjc7wQeKQCn0r0=", false, function() {
    return [
        useResizeObserver,
        useImageLoader,
        useAnimationLoop
    ];
});
_c1 = LogoLoop;
LogoLoop.displayName = "LogoLoop";
const __TURBOPACK__default__export__ = LogoLoop;
var _c, _c1;
__turbopack_context__.k.register(_c, "LogoLoop$memo");
__turbopack_context__.k.register(_c1, "LogoLoop");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=components_LogoLoop_tsx_91ca0106._.js.map