(globalThis.TURBOPACK || (globalThis.TURBOPACK = [])).push([typeof document === "object" ? document.currentScript : undefined,
"[project]/lib/constants.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "certifications",
    ()=>certifications,
    "companyStats",
    ()=>companyStats,
    "contactInfo",
    ()=>contactInfo,
    "faqItems",
    ()=>faqItems,
    "highlightStats",
    ()=>highlightStats,
    "jobFilterOptions",
    ()=>jobFilterOptions,
    "jobListings",
    ()=>jobListings,
    "services",
    ()=>services,
    "teamMembers",
    ()=>teamMembers,
    "testimonials",
    ()=>testimonials,
    "values",
    ()=>values
]);
const companyStats = [
    {
        number: "2,500+",
        label: "Successful Placements"
    },
    {
        number: "15+",
        label: "Destination Countries"
    },
    {
        number: "96%",
        label: "Satisfaction Rate"
    },
    {
        number: "100%",
        label: "Verified Employers"
    }
];
const highlightStats = [
    {
        number: "2,500+",
        label: "Successful Placements"
    },
    {
        number: "15+",
        label: "Destination Countries"
    },
    {
        number: "96%",
        label: "Candidate Satisfaction"
    },
    {
        number: "8+",
        label: "Years of Excellence"
    }
];
const services = [
    {
        id: "verified-employers",
        icon: "Shield",
        title: "Verified Employer Matching",
        description: "We conduct rigorous due diligence on international employers to ensure every opportunity is legitimate, ethical, and compliant with labor standards.",
        benefits: [
            "License validation",
            "Background checks",
            "Compliance reviews"
        ]
    },
    {
        id: "document-processing",
        icon: "FileCheck",
        title: "Document Processing Support",
        description: "Our team guides you through every document requirement, from passport verification to visa and attestation, ensuring a smooth process.",
        benefits: [
            "Visa guidance",
            "Attestation support",
            "Document checklists"
        ]
    },
    {
        id: "application-tracking",
        icon: "Radar",
        title: "Real-Time Application Tracking",
        description: "Stay informed with transparent, step-by-step updates from application submission to deployment.",
        benefits: [
            "Status updates",
            "Interview scheduling",
            "Clear timelines"
        ]
    },
    {
        id: "pre-departure",
        icon: "Briefcase",
        title: "Pre-Departure Orientation",
        description: "Prepare for success abroad with cultural orientation, job expectations, and legal rights education.",
        benefits: [
            "Cultural readiness",
            "Rights education",
            "Travel briefing"
        ]
    },
    {
        id: "post-placement",
        icon: "HeartHandshake",
        title: "Post-Placement Support",
        description: "We continue supporting you after placement through welfare checks and employer engagement.",
        benefits: [
            "Welfare support",
            "Issue resolution",
            "Employer liaison"
        ]
    },
    {
        id: "career-development",
        icon: "GraduationCap",
        title: "Career Development & Counseling",
        description: "Access career advice and skills guidance to help you grow in your international career path.",
        benefits: [
            "Career coaching",
            "Skills planning",
            "Growth roadmaps"
        ]
    }
];
const jobListings = [
    {
        id: "ahd-000156",
        title: "Registered Nurses (Multiple Positions)",
        country: "United Kingdom",
        location: "London, Manchester, Birmingham",
        reference: "AHD-000156",
        employmentType: "Full-time",
        sector: "Healthcare",
        requirements: [
            "Valid nursing degree and current registration",
            "Minimum 2 years post-qualification experience",
            "IELTS score of 7.0 or equivalent",
            "Willingness to complete UK NMC registration"
        ],
        salaryRange: "£28,000 - £38,000 per annum + benefits",
        verified: true,
        featured: true,
        postedDate: "2025-01-20",
        deadline: "2025-03-15",
        description: "Join leading NHS and private healthcare facilities in the UK. We provide end-to-end support from NMC application to relocation assistance.",
        responsibilities: [
            "Provide patient-centered care in clinical wards",
            "Collaborate with multi-disciplinary teams",
            "Maintain accurate clinical documentation",
            "Participate in continuous professional development"
        ],
        benefits: [
            "Relocation support",
            "Paid annual leave",
            "Continuing education sponsorship"
        ],
        documents: [
            "Updated CV",
            "Nursing degree certificates",
            "Professional registration",
            "Passport copy"
        ],
        employer: "Leading NHS & private healthcare partners"
    },
    {
        id: "ahd-000162",
        title: "Hospitality Staff (Hotels & Resorts)",
        country: "United Arab Emirates",
        location: "Dubai, Abu Dhabi",
        reference: "AHD-000162",
        employmentType: "Full-time",
        sector: "Hospitality",
        requirements: [
            "Minimum 1 year experience in hospitality",
            "Strong customer service skills",
            "Fluent in English (Arabic is a plus)",
            "Willingness to work shifts"
        ],
        salaryRange: "AED 2,800 - 3,600 + accommodation",
        verified: true,
        featured: true,
        postedDate: "2025-01-18",
        deadline: "2025-02-28",
        description: "Work in world-class hotels and resorts with structured career growth pathways and employer-provided accommodation.",
        responsibilities: [
            "Assist guests with check-in and check-out",
            "Maintain high cleanliness and service standards",
            "Coordinate with front-of-house teams"
        ],
        benefits: [
            "Accommodation provided",
            "Meals on duty",
            "Annual flight ticket"
        ],
        documents: [
            "Updated CV",
            "Certificate of service",
            "Passport copy"
        ],
        employer: "Premier hospitality groups in UAE"
    },
    {
        id: "ahd-000171",
        title: "Heavy Equipment Operators",
        country: "Qatar",
        location: "Doha, Lusail",
        reference: "AHD-000171",
        employmentType: "Contract",
        sector: "Construction",
        requirements: [
            "Valid heavy equipment license",
            "Minimum 3 years operating experience",
            "Knowledge of safety protocols",
            "Ability to work in hot environments"
        ],
        salaryRange: "QAR 3,500 - 4,500 + overtime",
        verified: true,
        featured: true,
        postedDate: "2025-01-15",
        deadline: "2025-03-05",
        description: "Operate excavators, bulldozers, and loaders on major infrastructure projects in Qatar.",
        responsibilities: [
            "Operate heavy equipment safely",
            "Conduct routine equipment checks",
            "Support site supervisors with logistics"
        ],
        benefits: [
            "Overtime pay",
            "Accommodation provided",
            "Medical cover"
        ],
        documents: [
            "Updated CV",
            "Equipment license",
            "Passport copy"
        ],
        employer: "Top-tier infrastructure contractors"
    },
    {
        id: "ahd-000182",
        title: "Elderly Care Assistants",
        country: "Canada",
        location: "Ontario, British Columbia",
        reference: "AHD-000182",
        employmentType: "Full-time",
        sector: "Healthcare",
        requirements: [
            "Caregiving certification or training",
            "Minimum 1 year experience in elder care",
            "Compassionate and patient-focused approach",
            "Basic English communication skills"
        ],
        salaryRange: "CAD 2,800 - 3,400 per month",
        verified: true,
        featured: false,
        postedDate: "2025-01-10",
        deadline: "2025-02-25",
        description: "Provide daily living support and companionship for senior residents in assisted living facilities.",
        responsibilities: [
            "Support personal care and mobility",
            "Monitor health and wellbeing",
            "Assist with meals and activities"
        ],
        benefits: [
            "Training provided",
            "Health insurance",
            "Pathway to PR"
        ],
        documents: [
            "Updated CV",
            "Caregiving certificate",
            "Passport copy"
        ],
        employer: "Leading senior care providers"
    },
    {
        id: "ahd-000193",
        title: "Security Guards",
        country: "Saudi Arabia",
        location: "Riyadh, Jeddah",
        reference: "AHD-000193",
        employmentType: "Full-time",
        sector: "Security",
        requirements: [
            "Security training certificate",
            "Minimum 2 years experience",
            "Physically fit and disciplined",
            "Basic English communication skills"
        ],
        salaryRange: "SAR 2,400 - 3,000 + housing",
        verified: true,
        featured: true,
        postedDate: "2025-01-08",
        deadline: "2025-02-20",
        description: "Join reputable security firms to safeguard commercial and residential facilities.",
        responsibilities: [
            "Monitor premises and access points",
            "Enforce safety procedures",
            "Report incidents and maintain logs"
        ],
        benefits: [
            "Housing allowance",
            "Medical cover",
            "Overtime"
        ],
        documents: [
            "Updated CV",
            "Security certificate",
            "Passport copy"
        ],
        employer: "Certified security companies in Saudi Arabia"
    },
    {
        id: "ahd-000207",
        title: "Professional Drivers",
        country: "United Arab Emirates",
        location: "Dubai, Sharjah",
        reference: "AHD-000207",
        employmentType: "Full-time",
        sector: "Logistics",
        requirements: [
            "Valid driving license (manual preferred)",
            "Minimum 3 years professional driving experience",
            "Clean driving record",
            "Basic vehicle maintenance knowledge"
        ],
        salaryRange: "AED 2,500 - 3,200 + overtime",
        verified: true,
        featured: false,
        postedDate: "2025-01-06",
        deadline: "2025-02-15",
        description: "Drive company vehicles for delivery and passenger services with competitive benefits.",
        responsibilities: [
            "Transport passengers or goods safely",
            "Maintain vehicle cleanliness",
            "Follow routing instructions"
        ],
        benefits: [
            "Overtime pay",
            "Accommodation support",
            "Annual leave"
        ],
        documents: [
            "Updated CV",
            "Driving license",
            "Passport copy"
        ],
        employer: "Trusted logistics and transport partners"
    },
    {
        id: "ahd-000218",
        title: "Skilled Welders (MIG/TIG)",
        country: "Germany",
        location: "Frankfurt, Hamburg",
        reference: "AHD-000218",
        employmentType: "Contract",
        sector: "Manufacturing",
        requirements: [
            "Certified MIG/TIG welder",
            "Minimum 4 years experience",
            "Ability to read technical drawings",
            "Basic German or willingness to learn"
        ],
        salaryRange: "€2,600 - €3,400 per month",
        verified: true,
        featured: true,
        postedDate: "2025-01-05",
        deadline: "2025-02-28",
        description: "Work with advanced manufacturing teams in Germany with clear contract terms and benefits.",
        responsibilities: [
            "Perform MIG/TIG welding to specification",
            "Inspect finished welds for quality",
            "Maintain equipment and workspace"
        ],
        benefits: [
            "Paid overtime",
            "Training support",
            "Accommodation guidance"
        ],
        documents: [
            "Updated CV",
            "Welding certificates",
            "Passport copy"
        ],
        employer: "Certified industrial manufacturers in Germany"
    },
    {
        id: "ahd-000229",
        title: "Agricultural Workers (Seasonal)",
        country: "Australia",
        location: "Queensland, Victoria",
        reference: "AHD-000229",
        employmentType: "Contract",
        sector: "Agriculture",
        requirements: [
            "Physically fit for field work",
            "Willingness to work outdoors",
            "Teamwork and reliability",
            "No prior experience required"
        ],
        salaryRange: "AUD 21 - 26 per hour",
        verified: true,
        featured: false,
        postedDate: "2025-01-03",
        deadline: "2025-02-10",
        description: "Seasonal agricultural roles with reputable farms, including harvesting and packing.",
        responsibilities: [
            "Harvest and sort produce",
            "Maintain cleanliness and safety",
            "Support packing and logistics"
        ],
        benefits: [
            "Overtime opportunities",
            "On-site training",
            "Seasonal bonuses"
        ],
        documents: [
            "Updated CV",
            "Passport copy"
        ],
        employer: "Licensed agricultural employers in Australia"
    }
];
const testimonials = [
    {
        id: "james-mwangi",
        name: "James Mwangi",
        role: "Security Guard, UAE",
        quote: "Ahadi Resources made my dream of working abroad a reality. The entire process was transparent, professional, and supportive. I'm now working in Dubai and my family's life has completely transformed.",
        rating: 5,
        image: "https://placehold.co/120x120/png"
    },
    {
        id: "grace-wanjiku",
        name: "Grace Wanjiku",
        role: "Registered Nurse, UK",
        quote: "I was nervous about leaving Kenya, but the team at Ahadi guided me every step of the way. From visa processing to pre-departure training, they were there. Now I'm thriving in my nursing career in the UK.",
        rating: 5,
        image: "https://placehold.co/120x120/png"
    },
    {
        id: "david-omondi",
        name: "David Omondi",
        role: "Heavy Equipment Operator, Qatar",
        quote: "What impressed me most was their commitment to ethical recruitment. No hidden fees, no false promises—just honest guidance toward a legitimate opportunity. I highly recommend Ahadi Resources.",
        rating: 5,
        image: "https://placehold.co/120x120/png"
    }
];
const values = [
    {
        title: "Trust & Transparency",
        description: "We communicate clearly and honestly at every stage, ensuring candidates understand the process and their rights."
    },
    {
        title: "Candidate Protection",
        description: "Our policies put candidate safety, welfare, and dignity at the heart of every placement."
    },
    {
        title: "Ethical Excellence",
        description: "We uphold the highest recruitment standards, guided by international labor frameworks."
    },
    {
        title: "Long-term Partnerships",
        description: "We build lasting relationships with candidates and employers to support sustainable success."
    }
];
const certifications = [
    "NEA Kenya License",
    "IRIS Certification",
    "FKE Membership",
    "ILO Convention Compliance"
];
const teamMembers = [
    {
        id: "faith-muthoni",
        name: "Faith Muthoni",
        role: "Managing Director",
        image: "https://placehold.co/400x400/png"
    },
    {
        id: "samuel-otieno",
        name: "Samuel Otieno",
        role: "Head of Recruitment",
        image: "https://placehold.co/400x400/png"
    },
    {
        id: "aisha-hassan",
        name: "Aisha Hassan",
        role: "Candidate Support Lead",
        image: "https://placehold.co/400x400/png"
    }
];
const faqItems = [
    {
        question: "How do I apply for a job?",
        answer: "Browse available positions, select a role that matches your profile, and complete the application form. Our team will guide you through the next steps."
    },
    {
        question: "What documents do I need?",
        answer: "Typical requirements include your passport, CV, certificates, and professional licenses. Specific roles may require additional documentation."
    },
    {
        question: "How long does the process take?",
        answer: "Timelines vary by employer and destination. Most placements take 6-12 weeks from application to deployment."
    },
    {
        question: "Are there any fees?",
        answer: "We operate with strict ethical recruitment standards. Any applicable costs are clearly communicated upfront."
    },
    {
        question: "How do I track my application?",
        answer: "You will receive regular updates through our support team and application status tracking."
    }
];
const contactInfo = {
    offices: [
        {
            city: "Nairobi",
            address: "Kenya Re Towers, 3rd Floor, Upperhill, Nairobi",
            mapLink: "https://maps.google.com/?q=Upperhill+Nairobi"
        },
        {
            city: "Dubai",
            address: "Business Bay, Bay Square, Dubai, UAE",
            mapLink: "https://maps.google.com/?q=Business+Bay+Dubai"
        }
    ],
    phone: [
        "+254 712 345 678",
        "+971 52 123 4567"
    ],
    email: "info@ahadiresources.com",
    whatsapp: "+254 700 000 000",
    hours: [
        "Mon - Fri: 8:00 AM - 6:00 PM",
        "Sat: 9:00 AM - 1:00 PM",
        "Sun: Closed"
    ]
};
const jobFilterOptions = {
    countries: [
        "United Kingdom",
        "United Arab Emirates",
        "Qatar",
        "Canada",
        "Saudi Arabia",
        "Germany",
        "Australia"
    ],
    sectors: [
        "Healthcare",
        "Hospitality",
        "Construction",
        "Security",
        "Logistics",
        "Manufacturing",
        "Agriculture"
    ],
    employmentTypes: [
        "Full-time",
        "Part-time",
        "Contract"
    ],
    skills: [
        "Customer service",
        "Patient care",
        "Driving",
        "Welding",
        "Safety compliance",
        "Team leadership",
        "Equipment operation",
        "Hospitality service"
    ],
    educationLevels: [
        "High School",
        "Diploma",
        "Bachelor's Degree",
        "Master's Degree",
        "Other"
    ]
};
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/lib/utils.ts [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "cn",
    ()=>cn,
    "formatDate",
    ()=>formatDate,
    "getCountryFlag",
    ()=>getCountryFlag
]);
function cn(...classes) {
    return classes.filter(Boolean).join(" ");
}
function formatDate(dateString) {
    if (!dateString) return "—";
    const date = new Date(dateString);
    if (Number.isNaN(date.getTime())) return dateString;
    return date.toLocaleDateString("en-KE", {
        year: "numeric",
        month: "short",
        day: "numeric"
    });
}
function getCountryFlag(country) {
    const flags = {
        "United Kingdom": "🇬🇧",
        "United Arab Emirates": "🇦🇪",
        Qatar: "🇶🇦",
        Canada: "🇨🇦",
        "Saudi Arabia": "🇸🇦",
        Germany: "🇩🇪",
        Australia: "🇦🇺"
    };
    return flags[country] ?? "🌍";
}
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/components/ui/Badge.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>Badge
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle2$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/circle-check.js [app-client] (ecmascript) <export default as CheckCircle2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/utils.ts [app-client] (ecmascript)");
;
;
;
const variantStyles = {
    verified: "bg-success-light text-success-dark",
    category: "bg-info-light text-info-dark",
    status: "bg-warning-light text-warning-dark",
    info: "bg-neutral-100 text-neutral-600"
};
const sizeStyles = {
    sm: "text-xs px-3 py-1",
    md: "text-xs px-3 py-1.5"
};
function Badge({ children, variant = "info", size = "sm", className }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["cn"])("inline-flex items-center gap-1 rounded-full font-semibold uppercase tracking-wide", variantStyles[variant], sizeStyles[size], className),
        children: [
            variant === "verified" ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$circle$2d$check$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__CheckCircle2$3e$__["CheckCircle2"], {
                className: "h-3 w-3",
                "aria-hidden": "true"
            }, void 0, false, {
                fileName: "[project]/components/ui/Badge.tsx",
                lineNumber: 40,
                columnNumber: 9
            }, this) : null,
            children
        ]
    }, void 0, true, {
        fileName: "[project]/components/ui/Badge.tsx",
        lineNumber: 31,
        columnNumber: 5
    }, this);
}
_c = Badge;
var _c;
__turbopack_context__.k.register(_c, "Badge");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/components/layout/Navigation.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>Navigation
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$constants$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/constants.ts [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$components$2f$ui$2f$Badge$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/components/ui/Badge.tsx [app-client] (ecmascript)");
;
;
;
;
const navLinks = [
    {
        href: "/",
        label: "Home"
    },
    {
        href: "/about",
        label: "About Us"
    },
    {
        href: "/services",
        label: "Services"
    },
    {
        href: "/jobs",
        label: "Jobs"
    },
    {
        href: "/contact",
        label: "Contact"
    }
];
function Navigation({ onNavigate, className }) {
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("nav", {
        className: className,
        "aria-label": "Main navigation",
        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("ul", {
            className: "flex flex-col gap-4 lg:flex-row lg:items-center lg:gap-8",
            children: navLinks.map((link)=>/*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("li", {
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                        href: link.href,
                        onClick: onNavigate,
                        className: "text-base font-medium text-neutral-600 transition hover:text-primary focus:outline-none focus:ring-2 focus:ring-accent focus:ring-offset-2",
                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("span", {
                            className: "inline-flex items-center gap-2",
                            children: [
                                link.label,
                                link.label === "Jobs" ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$components$2f$ui$2f$Badge$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                    variant: "info",
                                    size: "sm",
                                    children: __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$constants$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jobListings"].length
                                }, void 0, false, {
                                    fileName: "[project]/components/layout/Navigation.tsx",
                                    lineNumber: 33,
                                    columnNumber: 19
                                }, this) : null
                            ]
                        }, void 0, true, {
                            fileName: "[project]/components/layout/Navigation.tsx",
                            lineNumber: 30,
                            columnNumber: 15
                        }, this)
                    }, void 0, false, {
                        fileName: "[project]/components/layout/Navigation.tsx",
                        lineNumber: 25,
                        columnNumber: 13
                    }, this)
                }, link.href, false, {
                    fileName: "[project]/components/layout/Navigation.tsx",
                    lineNumber: 24,
                    columnNumber: 11
                }, this))
        }, void 0, false, {
            fileName: "[project]/components/layout/Navigation.tsx",
            lineNumber: 22,
            columnNumber: 7
        }, this)
    }, void 0, false, {
        fileName: "[project]/components/layout/Navigation.tsx",
        lineNumber: 21,
        columnNumber: 5
    }, this);
}
_c = Navigation;
var _c;
__turbopack_context__.k.register(_c, "Navigation");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/components/ui/Button.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>__TURBOPACK__default__export__
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$loader$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Loader2$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/loader-circle.js [app-client] (ecmascript) <export default as Loader2>");
var __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/lib/utils.ts [app-client] (ecmascript)");
;
;
;
;
const variantStyles = {
    primary: "bg-accent text-white hover:bg-accent-dark shadow-sm hover:shadow-md",
    secondary: "bg-primary text-white hover:bg-primary-dark shadow-sm hover:shadow-md",
    outline: "border-2 border-primary text-primary hover:bg-primary hover:text-white",
    ghost: "text-primary hover:bg-neutral-50"
};
const sizeStyles = {
    sm: "px-4 py-2 text-sm",
    md: "px-6 py-3 text-base",
    lg: "px-8 py-4 text-lg"
};
const Button = /*#__PURE__*/ __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["forwardRef"](_c = ({ className, variant = "primary", size = "md", fullWidth, icon, loading, disabled, children, ...props }, ref)=>{
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
        ref: ref,
        className: (0, __TURBOPACK__imported__module__$5b$project$5d2f$lib$2f$utils$2e$ts__$5b$app$2d$client$5d$__$28$ecmascript$29$__["cn"])("inline-flex items-center justify-center gap-2 rounded-lg font-semibold transition-all duration-300 focus:outline-none focus:ring-2 focus:ring-accent focus:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 hover:-translate-y-0.5", variantStyles[variant], sizeStyles[size], fullWidth && "w-full", className),
        disabled: disabled || loading,
        ...props,
        children: [
            loading ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$loader$2d$circle$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Loader2$3e$__["Loader2"], {
                className: "h-5 w-5 animate-spin"
            }, void 0, false, {
                fileName: "[project]/components/ui/Button.tsx",
                lineNumber: 61,
                columnNumber: 20
            }, ("TURBOPACK compile-time value", void 0)) : icon,
            children
        ]
    }, void 0, true, {
        fileName: "[project]/components/ui/Button.tsx",
        lineNumber: 49,
        columnNumber: 7
    }, ("TURBOPACK compile-time value", void 0));
});
_c1 = Button;
Button.displayName = "Button";
const __TURBOPACK__default__export__ = Button;
var _c, _c1;
__turbopack_context__.k.register(_c, "Button$React.forwardRef");
__turbopack_context__.k.register(_c1, "Button");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
"[project]/components/layout/Header.tsx [app-client] (ecmascript)", ((__turbopack_context__) => {
"use strict";

__turbopack_context__.s([
    "default",
    ()=>Header
]);
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/jsx-dev-runtime.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/compiled/react/index.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/dist/client/app-dir/link.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/next/image.js [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/framer-motion/dist/es/components/AnimatePresence/index.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/node_modules/framer-motion/dist/es/render/components/motion/proxy.mjs [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$menu$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Menu$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/menu.js [app-client] (ecmascript) <export default as Menu>");
var __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__ = __turbopack_context__.i("[project]/node_modules/lucide-react/dist/esm/icons/x.js [app-client] (ecmascript) <export default as X>");
var __TURBOPACK__imported__module__$5b$project$5d2f$components$2f$layout$2f$Navigation$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/components/layout/Navigation.tsx [app-client] (ecmascript)");
var __TURBOPACK__imported__module__$5b$project$5d2f$components$2f$ui$2f$Button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__ = __turbopack_context__.i("[project]/components/ui/Button.tsx [app-client] (ecmascript)");
;
var _s = __turbopack_context__.k.signature();
"use client";
;
;
;
;
;
;
;
function Header() {
    _s();
    const [isOpen, setIsOpen] = (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$index$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["useState"])(false);
    return /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("header", {
        className: "relative z-50 bg-neutral-50/80 py-0.5 backdrop-blur",
        children: [
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                className: "container-custom",
                children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                    className: "flex h-14 items-center justify-between rounded-2xl border border-neutral-200 bg-white px-5 shadow-sm lg:h-[68px]",
                    children: [
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                            href: "/",
                            className: "flex items-center min-w-[140px]",
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                src: "/images/logo.png",
                                alt: "Ahadi Resources logo",
                                width: 180,
                                height: 52,
                                priority: true,
                                className: "h-9 w-auto object-contain"
                            }, void 0, false, {
                                fileName: "[project]/components/layout/Header.tsx",
                                lineNumber: 21,
                                columnNumber: 13
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/components/layout/Header.tsx",
                            lineNumber: 20,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                            className: "hidden items-center gap-10 lg:flex",
                            children: [
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$components$2f$layout$2f$Navigation$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {}, void 0, false, {
                                    fileName: "[project]/components/layout/Header.tsx",
                                    lineNumber: 32,
                                    columnNumber: 13
                                }, this),
                                /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                    href: "/apply",
                                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$components$2f$ui$2f$Button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                        variant: "primary",
                                        size: "md",
                                        className: "rounded-full px-7",
                                        children: "Apply Now"
                                    }, void 0, false, {
                                        fileName: "[project]/components/layout/Header.tsx",
                                        lineNumber: 34,
                                        columnNumber: 15
                                    }, this)
                                }, void 0, false, {
                                    fileName: "[project]/components/layout/Header.tsx",
                                    lineNumber: 33,
                                    columnNumber: 13
                                }, this)
                            ]
                        }, void 0, true, {
                            fileName: "[project]/components/layout/Header.tsx",
                            lineNumber: 31,
                            columnNumber: 11
                        }, this),
                        /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                            type: "button",
                            className: "inline-flex h-11 w-11 items-center justify-center rounded-full border border-neutral-200 text-neutral-600 transition hover:bg-neutral-50 focus:outline-none focus:ring-2 focus:ring-accent focus:ring-offset-2 lg:hidden",
                            "aria-label": "Open menu",
                            "aria-expanded": isOpen,
                            "aria-controls": "mobile-menu",
                            onClick: ()=>setIsOpen(true),
                            children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$menu$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__Menu$3e$__["Menu"], {
                                className: "h-6 w-6"
                            }, void 0, false, {
                                fileName: "[project]/components/layout/Header.tsx",
                                lineNumber: 48,
                                columnNumber: 13
                            }, this)
                        }, void 0, false, {
                            fileName: "[project]/components/layout/Header.tsx",
                            lineNumber: 40,
                            columnNumber: 11
                        }, this)
                    ]
                }, void 0, true, {
                    fileName: "[project]/components/layout/Header.tsx",
                    lineNumber: 17,
                    columnNumber: 9
                }, this)
            }, void 0, false, {
                fileName: "[project]/components/layout/Header.tsx",
                lineNumber: 16,
                columnNumber: 7
            }, this),
            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$components$2f$AnimatePresence$2f$index$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["AnimatePresence"], {
                children: isOpen ? /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["motion"].div, {
                    className: "fixed inset-0 z-50 bg-black/40 backdrop-blur-sm lg:hidden",
                    initial: {
                        opacity: 0
                    },
                    animate: {
                        opacity: 1
                    },
                    exit: {
                        opacity: 0
                    },
                    onClick: ()=>setIsOpen(false),
                    children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$framer$2d$motion$2f$dist$2f$es$2f$render$2f$components$2f$motion$2f$proxy$2e$mjs__$5b$app$2d$client$5d$__$28$ecmascript$29$__["motion"].div, {
                        id: "mobile-menu",
                        className: "absolute right-0 top-0 h-full w-full max-w-sm bg-white p-6 shadow-xl",
                        initial: {
                            x: "100%"
                        },
                        animate: {
                            x: 0
                        },
                        exit: {
                            x: "100%"
                        },
                        transition: {
                            duration: 0.3,
                            ease: "easeOut"
                        },
                        onClick: (event)=>event.stopPropagation(),
                        children: [
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "flex items-center justify-between",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                        href: "/",
                                        onClick: ()=>setIsOpen(false),
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$image$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                            src: "/images/logo.png",
                                            alt: "Ahadi Resources logo",
                                            width: 140,
                                            height: 40
                                        }, void 0, false, {
                                            fileName: "[project]/components/layout/Header.tsx",
                                            lineNumber: 73,
                                            columnNumber: 19
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/components/layout/Header.tsx",
                                        lineNumber: 72,
                                        columnNumber: 17
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("button", {
                                        type: "button",
                                        className: "inline-flex h-11 w-11 items-center justify-center rounded-full border border-neutral-200 text-neutral-600 transition hover:bg-neutral-50 focus:outline-none focus:ring-2 focus:ring-accent focus:ring-offset-2",
                                        "aria-label": "Close menu",
                                        onClick: ()=>setIsOpen(false),
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$lucide$2d$react$2f$dist$2f$esm$2f$icons$2f$x$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__$3c$export__default__as__X$3e$__["X"], {
                                            className: "h-6 w-6"
                                        }, void 0, false, {
                                            fileName: "[project]/components/layout/Header.tsx",
                                            lineNumber: 86,
                                            columnNumber: 19
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/components/layout/Header.tsx",
                                        lineNumber: 80,
                                        columnNumber: 17
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/components/layout/Header.tsx",
                                lineNumber: 71,
                                columnNumber: 15
                            }, this),
                            /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])("div", {
                                className: "mt-8 space-y-6",
                                children: [
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$components$2f$layout$2f$Navigation$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                        onNavigate: ()=>setIsOpen(false)
                                    }, void 0, false, {
                                        fileName: "[project]/components/layout/Header.tsx",
                                        lineNumber: 90,
                                        columnNumber: 17
                                    }, this),
                                    /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$client$2f$app$2d$dir$2f$link$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                        href: "/apply",
                                        onClick: ()=>setIsOpen(false),
                                        children: /*#__PURE__*/ (0, __TURBOPACK__imported__module__$5b$project$5d2f$node_modules$2f$next$2f$dist$2f$compiled$2f$react$2f$jsx$2d$dev$2d$runtime$2e$js__$5b$app$2d$client$5d$__$28$ecmascript$29$__["jsxDEV"])(__TURBOPACK__imported__module__$5b$project$5d2f$components$2f$ui$2f$Button$2e$tsx__$5b$app$2d$client$5d$__$28$ecmascript$29$__["default"], {
                                            variant: "primary",
                                            size: "md",
                                            fullWidth: true,
                                            children: "Apply Now"
                                        }, void 0, false, {
                                            fileName: "[project]/components/layout/Header.tsx",
                                            lineNumber: 92,
                                            columnNumber: 19
                                        }, this)
                                    }, void 0, false, {
                                        fileName: "[project]/components/layout/Header.tsx",
                                        lineNumber: 91,
                                        columnNumber: 17
                                    }, this)
                                ]
                            }, void 0, true, {
                                fileName: "[project]/components/layout/Header.tsx",
                                lineNumber: 89,
                                columnNumber: 15
                            }, this)
                        ]
                    }, void 0, true, {
                        fileName: "[project]/components/layout/Header.tsx",
                        lineNumber: 62,
                        columnNumber: 13
                    }, this)
                }, void 0, false, {
                    fileName: "[project]/components/layout/Header.tsx",
                    lineNumber: 55,
                    columnNumber: 11
                }, this) : null
            }, void 0, false, {
                fileName: "[project]/components/layout/Header.tsx",
                lineNumber: 53,
                columnNumber: 7
            }, this)
        ]
    }, void 0, true, {
        fileName: "[project]/components/layout/Header.tsx",
        lineNumber: 15,
        columnNumber: 5
    }, this);
}
_s(Header, "+sus0Lb0ewKHdwiUhiTAJFoFyQ0=");
_c = Header;
var _c;
__turbopack_context__.k.register(_c, "Header");
if (typeof globalThis.$RefreshHelpers$ === 'object' && globalThis.$RefreshHelpers !== null) {
    __turbopack_context__.k.registerExports(__turbopack_context__.m, globalThis.$RefreshHelpers$);
}
}),
]);

//# sourceMappingURL=_8ece7b62._.js.map